/*
 * Decompiled with CFR 0.152.
 */
package itineraryfinder;

import com.byteowls.jopencage.JOpenCageGeocoder;
import com.byteowls.jopencage.model.JOpenCageForwardRequest;
import com.byteowls.jopencage.model.JOpenCageResponse;
import com.byteowls.jopencage.model.JOpenCageResult;
import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXDialog;
import com.jfoenix.controls.JFXDialogLayout;
import com.jfoenix.controls.JFXListView;
import com.jfoenix.controls.JFXTextField;
import itineraryfinder.Place;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.ResourceBundle;
import javafx.application.HostServices;
import javafx.application.Platform;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.concurrent.Worker;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.ListCell;
import javafx.scene.control.MenuItem;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.text.Text;
import org.controlsfx.dialog.ProgressDialog;
import salesmansolver.Chromosome;
import salesmansolver.Gene;
import salesmansolver.Population;

public class ItineraryFinderController
implements Initializable {
    private final JOpenCageGeocoder geocoder = new JOpenCageGeocoder("81967e28ae5a4d47858df3a1eb737805");
    public HostServices hostServices;
    String startingCity;
    @FXML
    private StackPane stackPane;
    @FXML
    JFXTextField searchTextField;
    @FXML
    JFXTextField iterationsNumberField;
    @FXML
    JFXTextField mutationRateField;
    @FXML
    JFXButton searchButton;
    @FXML
    JFXButton findButton;
    @FXML
    JFXButton clearButton;
    @FXML
    JFXButton clearCitiesButton;
    @FXML
    JFXButton showOnMapButton;
    @FXML
    JFXListView placeListView;
    private ObservableList<String> observablePlaceList;
    private final ArrayList<Place> placeList = new ArrayList();
    @FXML
    JFXListView suggestionsListView;
    private ObservableList<String> observableSuggestionsList;
    private final ArrayList<Place> placeSuggestions = new ArrayList();
    @FXML
    Text cityNumberText;
    @FXML
    Text startingCityText;
    @FXML
    Text distanceNumberText;
    @FXML
    Text finalDistance;
    private final ArrayList<String> suggestionsToAdd = new ArrayList();

    @FXML
    public void clearCitiesPressed() {
        this.observablePlaceList.clear();
        this.placeList.clear();
        this.placeListView.setItems(this.observablePlaceList);
        this.cityNumberText.setText("0");
        this.setStartingCity(-1);
        this.showOnMapButton.setDisable(true);
    }

    @FXML
    public void findButtonPressed() {
        int i;
        if (this.observablePlaceList.size() < 3) {
            return;
        }
        int iterations = 1000;
        try {
            iterations = Integer.parseInt(this.iterationsNumberField.getText());
        }
        catch (NumberFormatException e) {
            System.out.println("No valid iterations number, using 1000");
        }
        double mutation_rate = Double.min(1 / this.observablePlaceList.size(), 0.01);
        try {
            mutation_rate = Double.parseDouble(this.mutationRateField.getText());
            System.out.println("Mutation rate: " + (mutation_rate /= 100.0));
        }
        catch (NumberFormatException e) {
            System.out.println("Using the default mutation rate");
        }
        Population p = new Population(200);
        LinkedHashMap<Integer, Gene> l = new LinkedHashMap<Integer, Gene>();
        LinkedHashMap<String, Place> placeByName = new LinkedHashMap<String, Place>();
        for (int i2 = 0; i2 < this.placeList.size(); ++i2) {
            l.put(i2, new Gene(this.placeList.get((int)i2).address, this.placeList.get((int)i2).latLng.lat, this.placeList.get((int)i2).latLng.lng));
            placeByName.put(this.placeList.get((int)i2).address, this.placeList.get(i2));
        }
        Task task = this.createTaskItinerary(p, l, iterations, mutation_rate);
        ProgressDialog dialog = new ProgressDialog((Worker)task);
        dialog.setTitle("Searching...");
        dialog.setHeaderText("Searching for the best itinerary...");
        new Thread((Runnable)task).start();
        dialog.showAndWait();
        this.placeList.clear();
        this.observablePlaceList.clear();
        Chromosome bestPath = p.bestPath();
        this.finalDistance.setText(new DecimalFormat("#.##").format(bestPath.getRouteDistance()) + " Km");
        ArrayList tmpPlace = new ArrayList();
        ArrayList<String> tmpString = new ArrayList<String>();
        int index = -1;
        for (i = 0; i < bestPath.size(); ++i) {
            if (this.startingCity.equals(bestPath.get(i).toString())) {
                index = i;
                break;
            }
            tmpPlace.add(placeByName.get(bestPath.get(i).toString()));
            tmpString.add(bestPath.get(i).toString());
        }
        if (index >= 0) {
            for (i = index; i < bestPath.size(); ++i) {
                this.placeList.add((Place)placeByName.get(bestPath.get(i).toString()));
                this.observablePlaceList.add((Object)bestPath.get(i).toString());
            }
            this.placeList.addAll(tmpPlace);
            this.observablePlaceList.addAll(tmpString);
            this.placeListView.setItems(this.observablePlaceList);
            System.out.println("FINAL BEST PATH: " + p.bestPath());
            System.out.println("FINAL WORST PATH: " + p.worstPath());
        } else {
            System.err.println("Starting city not setted!");
        }
    }

    private Task createTaskItinerary(final Population p, final LinkedHashMap<Integer, Gene> l, final int iterations, final double mutation_rate) {
        return new Task(){

            protected Void call() throws Exception {
                p.initialPopulation(l);
                this.updateMessage("Number of generations: 0\nBest path: " + new DecimalFormat("#.##").format(p.bestPath().getRouteDistance()) + " Km, Current gen: " + new DecimalFormat("#.##").format(p.getCurrentGenerationBestPath()) + "Km\n  ");
                Thread.sleep(500L);
                for (int i = 0; i < iterations; ++i) {
                    this.updateMessage("Number of generations: " + i + "\nBest path: " + new DecimalFormat("#.##").format(p.bestPath().getRouteDistance()) + " Km, Current gen: " + new DecimalFormat("#.##").format(p.getCurrentGenerationBestPath()) + "Km\n  ");
                    this.updateProgress(i, iterations);
                    p.nextGeneration(200, 50, mutation_rate);
                }
                return null;
            }
        };
    }

    @FXML
    public void clearButtonPressed() {
        this.clearSuggestions();
    }

    @FXML
    public void searchButtonPressed() {
        this.clearSuggestions();
        this.setSuggestions(this.searchTextField.getText());
    }

    @FXML
    public void onEnter() {
        this.clearSuggestions();
        this.setSuggestions(this.searchTextField.getText());
    }

    @FXML
    public void suggestionClicked(MouseEvent event) {
        if (event.getButton().equals((Object)MouseButton.PRIMARY) && event.getClickCount() == 2) {
            if (this.suggestionsListView.getSelectionModel().isEmpty()) {
                return;
            }
            int i = this.suggestionsListView.getSelectionModel().getSelectedIndex();
            if (!this.observablePlaceList.contains((Object)this.placeSuggestions.toString())) {
                this.observablePlaceList.add((Object)this.placeSuggestions.get((int)i).address);
                this.placeList.add(this.placeSuggestions.get(i));
                if (this.placeList.size() == 1) {
                    this.setStartingCity(0);
                }
                this.cityNumberText.setText(String.valueOf(Integer.parseInt(this.cityNumberText.getText()) + 1));
            }
            this.placeListView.setItems(this.observablePlaceList);
            this.showOnMapButton.setDisable(false);
        }
    }

    public void initialize(URL url, ResourceBundle rb) {
        this.iterationsNumberField.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                if (!newValue.matches("\\d*") || newValue.length() > 4) {
                    ItineraryFinderController.this.iterationsNumberField.setText(oldValue);
                }
            }
        });
        this.mutationRateField.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                int newIntValue = 101;
                try {
                    newIntValue = Integer.parseInt(newValue);
                }
                catch (NumberFormatException e) {
                    if (newValue.isEmpty()) {
                        newIntValue = 1;
                    }
                }
                finally {
                    if (!newValue.matches("\\d*") || newIntValue > 100) {
                        ItineraryFinderController.this.mutationRateField.setText(oldValue);
                    }
                }
            }
        });
        this.observablePlaceList = FXCollections.observableArrayList();
        this.observableSuggestionsList = FXCollections.observableArrayList();
        this.placeListView.setCellFactory(lv -> {
            ListCell cell = new ListCell();
            ContextMenu contextMenu = new ContextMenu();
            MenuItem startItem = new MenuItem();
            startItem.textProperty().bind((ObservableValue)Bindings.format((String)"Make \"%s\" the starting city", (Object[])new Object[]{cell.itemProperty()}));
            startItem.setOnAction(event -> {
                int i = this.placeListView.getItems().indexOf(cell.getItem());
                this.setStartingCity(i);
            });
            MenuItem infoItem = new MenuItem();
            infoItem.textProperty().bind((ObservableValue)Bindings.format((String)"Info \"%s\"", (Object[])new Object[]{cell.itemProperty()}));
            infoItem.setOnAction(event -> {
                int i = this.placeListView.getItems().indexOf(cell.getItem());
                JFXDialogLayout content = new JFXDialogLayout();
                content.setHeading(new Node[]{new Text(this.placeList.get((int)i).address)});
                GridPane dialogPane = new GridPane();
                dialogPane.setHgap(10.0);
                dialogPane.setVgap(10.0);
                Text infoLat = new Text("Latitude: " + this.placeList.get((int)i).latLng.lat);
                Text infoLng = new Text("Longitude: " + this.placeList.get((int)i).latLng.lng);
                Text infoGeneric = new Text("Look at it on Google Maps:");
                infoGeneric.setUnderline(true);
                final Hyperlink link = new Hyperlink(this.placeList.get((int)i).link);
                link.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                    public void handle(ActionEvent t) {
                        ItineraryFinderController.this.hostServices.showDocument(link.getText());
                    }
                });
                dialogPane.add((Node)infoLat, 0, 0);
                dialogPane.add((Node)infoLng, 0, 1);
                dialogPane.add((Node)infoGeneric, 0, 2);
                dialogPane.add((Node)link, 1, 2);
                content.setBody(new Node[]{dialogPane});
                StackPane stackpane = new StackPane();
                final JFXDialog dialog = new JFXDialog(this.stackPane, (Region)content, JFXDialog.DialogTransition.CENTER);
                JFXButton button = new JFXButton(" OK ");
                button.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                    public void handle(ActionEvent event) {
                        dialog.close();
                    }
                });
                content.setActions(new Node[]{button});
                dialog.show();
            });
            MenuItem deleteItem = new MenuItem();
            deleteItem.textProperty().bind((ObservableValue)Bindings.format((String)"Delete \"%s\"", (Object[])new Object[]{cell.itemProperty()}));
            deleteItem.setOnAction(event -> {
                int i = this.placeListView.getItems().indexOf(cell.getItem());
                this.placeListView.getItems().remove(i);
                String removed = this.placeList.remove((int)i).address;
                if (this.observablePlaceList.isEmpty()) {
                    this.showOnMapButton.setDisable(true);
                }
                if (removed.equals(this.startingCity)) {
                    if (this.placeList.isEmpty()) {
                        this.setStartingCity(-1);
                    } else {
                        this.setStartingCity(0);
                    }
                }
                this.cityNumberText.setText(String.valueOf(Integer.parseInt(this.cityNumberText.getText()) - 1));
            });
            contextMenu.getItems().addAll((Object[])new MenuItem[]{infoItem, deleteItem, startItem});
            cell.textProperty().bind((ObservableValue)cell.itemProperty());
            cell.emptyProperty().addListener((obs, wasEmpty, isNowEmpty) -> {
                if (isNowEmpty.booleanValue()) {
                    cell.setContextMenu(null);
                } else {
                    cell.setContextMenu(contextMenu);
                }
            });
            return cell;
        });
    }

    public void setStartingCity(int index) {
        if (index < 0) {
            this.startingCity = "-";
            this.startingCityText.setText("-");
        } else {
            this.startingCity = this.placeList.get((int)index).address;
            if (this.startingCity.length() > 18) {
                this.startingCityText.setText(this.startingCity.substring(0, 15) + "...");
            } else {
                this.startingCityText.setText(this.placeList.get((int)index).address);
            }
            ArrayList<Place> tmp = new ArrayList<Place>();
            tmp.addAll(this.placeList.subList(index, this.placeList.size()));
            tmp.addAll(this.placeList.subList(0, index));
            this.placeList.clear();
            this.observablePlaceList.clear();
            for (Place p : tmp) {
                this.placeList.add(p);
                this.observablePlaceList.add((Object)p.address);
            }
        }
    }

    public HostServices getHostServices() {
        return this.hostServices;
    }

    public void setHostServices(HostServices hostServices) {
        this.hostServices = hostServices;
    }

    private void clearSuggestions() {
        this.placeSuggestions.clear();
        this.observableSuggestionsList.clear();
        this.suggestionsListView.setItems(this.observableSuggestionsList);
    }

    private void setSuggestions(String address) {
        Task task = this.createTaskSearch(address);
        ProgressDialog dialog = new ProgressDialog((Worker)task);
        dialog.setTitle("Searching...");
        dialog.setHeaderText("Searching for cities...");
        new Thread((Runnable)task).start();
        dialog.showAndWait();
    }

    private Task createTaskSearch(final String address) {
        return new Task(){

            protected Void call() throws Exception {
                JOpenCageForwardRequest request = new JOpenCageForwardRequest(address);
                request.setNoDedupe(true);
                request.setLimit(Integer.valueOf(6));
                request.setNoAnnotations(true);
                JOpenCageResponse response = ItineraryFinderController.this.geocoder.forward(request);
                if (response.getResults().isEmpty()) {
                    System.err.println("Errore: Nessuna localit\u00e0 trovata!");
                }
                for (JOpenCageResult r : response.getResults()) {
                    Place place = new Place(r.getFormatted(), r.getGeometry().getLat(), r.getGeometry().getLng(), ItineraryFinderController.this.getLink(r));
                    if (ItineraryFinderController.this.observableSuggestionsList.contains((Object)place.toString())) continue;
                    ItineraryFinderController.this.suggestionsToAdd.add(place.toString());
                    ItineraryFinderController.this.placeSuggestions.add(place);
                }
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        for (String place : ItineraryFinderController.this.suggestionsToAdd) {
                            ItineraryFinderController.this.observableSuggestionsList.add((Object)place);
                        }
                        ItineraryFinderController.this.suggestionsListView.setItems(ItineraryFinderController.this.observableSuggestionsList);
                        ItineraryFinderController.this.suggestionsToAdd.clear();
                    }
                });
                return null;
            }
        };
    }

    private String getLink(JOpenCageResult r) {
        String result = r.getFormatted();
        result = result.replace(" ", "+");
        result = result.replace(",", "%2C");
        return "https://www.google.com/maps/search/?api=1&query=" + result;
    }

    @FXML
    public void showOnMapPressed() {
        this.hostServices.showDocument(this.getLinkFromList());
    }

    private String getLinkFromList() {
        String parameters = "";
        parameters = parameters + "&origin=" + this.placeList.get((int)0).URLaddress;
        parameters = parameters + "&waypoints=";
        for (int i = 1; i < this.placeList.size(); ++i) {
            System.err.println(this.placeList.get((int)i).URLaddress);
            parameters = parameters + this.placeList.get((int)i).URLaddress;
            if (i >= this.placeList.size() - 1) continue;
            parameters = parameters + "%7C";
        }
        parameters = parameters + "&destination=" + this.placeList.get((int)0).URLaddress;
        return "https://www.google.com/maps/dir/?api=1" + parameters;
    }
}

